package gov.va.med.mhv.usermgmt.bizobj;

import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;

import java.lang.reflect.Method;

import org.apache.commons.lang.StringUtils;

/**
 * Business object for the EmergencyContact application entity
 *
 * Generated Skeleton Code
 */
 
public class EmergencyContactBO extends EmergencyContactBaseBO {
	
	protected void complexValidation() {
		validateStateAndProvinceAndCountry();
		validateContactMethodProvided();
	}

	private void validateStateAndProvinceAndCountry() {	
		if( StringUtils.isNotBlank( getAddressProvince() ) && getAddressState() != null ) {
			addError( UserManagementMessages.PROVINCE_OR_STATE, new Object[] {} );
		}
		
		if( getAddressCountry() != null ) {
			if( CountryEnumeration.UNITED_STATES.equals( getAddressCountry().getName() ) ) {
				if( getAddressState() == null ) {
					addError( UserManagementMessages.STATE_REQUIRED, new Object[] {} );
				}
			}
			else if( CountryEnumeration.CANADA.equals( getAddressCountry().getName() ) ){
				if( StringUtils.isBlank( getAddressProvince() ) ) {
					addError( UserManagementMessages.PROVINCE_REQUIRED, new Object[] {} );
				}
			}
		}
		else if( getAddressState() != null || StringUtils.isNotBlank( getAddressProvince() ) ) {
			addError( UserManagementMessages.COUNTRY_REQUIRED, new Object[] {} );
		}		
	}
	
	private void validateContactMethodProvided() {

		if( getContactInfoContactMethod() == null ) {
			return;
		}
		
		String contactMethodMethodName = "getContactInfo" + getContactInfoContactMethod().getName();
		try {
			Method contactMethodMethod = getClass().getMethod( contactMethodMethodName, null );
			String contactNumber = (String) contactMethodMethod.invoke( this, null );
			if( StringUtils.isBlank( contactNumber ) ) {
				addError( UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, new Object[] {} );
			}
		} catch (Exception e) {
			addError( UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, new Object[] {} );
		}
		
	}	
	
	protected void normalize() {
	/*
		setContactInfoHomePhone( PhoneNumberFormatter.format( getContactInfoHomePhone() ) );
		setContactInfoWorkPhone( PhoneNumberFormatter.format( getContactInfoWorkPhone() ) );
		setContactInfoMobilePhone( PhoneNumberFormatter.format( getContactInfoMobilePhone() ) );
		setContactInfoFax( PhoneNumberFormatter.format( getContactInfoFax() ) );
		setContactInfoPager( PhoneNumberFormatter.format( getContactInfoPager() ) );
	*/
	}
}